import React from 'react';
import PropTypes from 'prop-types';

import {List, Icon, Button} from '@yandex-id/components';

import {DocumentsDrawer} from '../Drawer/Documents-Drawer';

import {cnDocuments} from '../constants';

export const DocumentsFooter = (props) => {
    const {
        isRegisterRequired,
        openRegisterMenu,
        groups,
        isPhone,
        onToogleMenu,
        onCloseMenu,
        isMenuVisible,
        scopeRef
    } = props;

    return (
        <>
            <div className={cnDocuments('Footer')}>
                <Button
                    className={cnDocuments('Add', {isPhone})}
                    pin='circle-circle'
                    size='l'
                    icon={(className) => <Icon className={cnDocuments('DocIcon', [className])} glyph='addDocument' />}
                    onClick={isRegisterRequired ? openRegisterMenu : onToogleMenu}
                >
                    {i18n('Profile2.documents.additionTitle')}
                </Button>
            </div>
            {!isRegisterRequired && (
                <DocumentsDrawer scopeRef={scopeRef} visible={isMenuVisible} onClose={onCloseMenu}>
                    <List
                        className={cnDocuments('List', {menu: true})}
                        header={<div className={cnDocuments('ListHeader', {menu: true})}>Добавить документ</div>}
                        groups={groups}
                    />
                </DocumentsDrawer>
            )}
        </>
    );
};

DocumentsFooter.propTypes = {
    isRegisterRequired: PropTypes.bool,
    openRegisterMenu: PropTypes.func,
    groups: PropTypes.array,
    isPhone: PropTypes.bool,
    isMenuVisible: PropTypes.bool,
    scopeRef: PropTypes.object,
    onToogleMenu: PropTypes.func,
    onCloseMenu: PropTypes.func
};
