import React from 'react';
import PropTypes from 'prop-types';

import {Divider, ListItem, ListGroups} from '@yandex-id/components';

import {DocumentsListItem} from '../Item/Documents-ListItem';

import {cnDocuments, docs} from '../../constants';

export const DocumentsListGroup = (props) => {
    const {
        userUid,
        isRegisterRequired,
        lang,
        openRegisterMenu,
        groupTitle,
        items: rawItems = [],
        withHeader = false,
        type,
        scope
    } = props;

    const items = rawItems.reduce((acc, item, index) => {
        const docTitle = docs[item.id][lang];

        const document = (
            <DocumentsListItem
                userUid={userUid}
                isRegisterRequired={isRegisterRequired}
                docId={item.id}
                docTitle={docTitle}
                scope={scope}
            />
        );
        const itemContent = isRegisterRequired ? <div onClick={openRegisterMenu}>{document}</div> : document;

        acc.push(
            <ListItem
                key={index}
                header={index > 0 ? <Divider className={cnDocuments('Divider')} color={'#e6e9f0'} /> : undefined}
            >
                {itemContent}
            </ListItem>
        );

        return acc;
    }, []);

    const header = withHeader ? <div className={cnDocuments('ListGroup-Header')}>{groupTitle}</div> : null;

    return <ListGroups className={cnDocuments('ListGroup', {type})} header={header} items={items} />;
};

DocumentsListGroup.propTypes = {
    userUid: PropTypes.number.isRequired,
    isRegisterRequired: PropTypes.bool.isRequired,
    openRegisterMenu: PropTypes.func.isRequired,
    lang: PropTypes.string,
    type: PropTypes.string,
    items: PropTypes.array,
    groupTitle: PropTypes.string,
    withHeader: PropTypes.bool,
    scope: PropTypes.object
};
