import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import './Documents-ListHeader.styl';

const cnListHeader = cn('ListHeader');

export const DocumentsListHeader = ({isInitializing, isYaApp}) => {
    const headerTitle = isYaApp ? undefined : i18n('Profile2.documents.navigation');

    return (
        <div className={cnListHeader('', {isInitializing})}>
            <div className={cnListHeader('', {upper: true})}>
                <div className={cnListHeader('Left')}>
                    <div className={cnListHeader('Left', {upper: true})}>{headerTitle}</div>
                </div>
            </div>
        </div>
    );
};

DocumentsListHeader.propTypes = {
    isInitializing: PropTypes.bool,
    isYaApp: PropTypes.bool
};
