import React from 'react';
import PropTypes from 'prop-types';

import {Popup} from '@yandex-id/components';

import {cnDocuments} from '../constants';

export const DocumentsPopup = (props) => {
    const {children, scope = 'inplace', view = 'default', ...restProps} = props;

    return (
        <Popup view={view} scope={scope} className={cnDocuments('Menu')} {...restProps}>
            {children}
        </Popup>
    );
};

DocumentsPopup.propTypes = {
    children: PropTypes.element,
    view: PropTypes.string,
    scope: PropTypes.object,
    target: PropTypes.string,
    anchor: PropTypes.object,
    visible: PropTypes.bool,
    onClose: PropTypes.func
};
