import React from 'react';
import PropTypes from 'prop-types';

import {Link} from '@components/Link';

import {cnDocuments} from '../constants';
import {DocumentsDrawer} from '../Drawer/Documents-Drawer';
import {DocumentsPopup} from '../Popup/Documents-Popup';
import {Button} from '@yandex-id/components';

export const Registration = (props) => {
    const {isPhone, isBlockVisible, scopeRef, onClose} = props;

    const content = (
        <div className={cnDocuments('Registration')}>
            <div className={cnDocuments('Registration-Logo')} />
            <div className={cnDocuments('Registration-Title')}>{i18n('Profile2.documents.register.title')}</div>
            <div className={cnDocuments('Registration-Description')}>
                {i18n('Profile2.documents.register.description')}
            </div>
            <Link
                className={cnDocuments('Registration-Continue')}
                view='default'
                theme='black'
                href='/profile/upgrade?origin=passport_documents'
            >
                <Button className={cnDocuments('Registration-Continue')} view='action' width='max'>
                    {i18n('Profile2.documents.register.continue')}
                </Button>
            </Link>
        </div>
    );

    const mainElement = isPhone ? (
        <DocumentsDrawer visible={isBlockVisible} scopeRef={scopeRef} onClose={onClose}>
            {content}
        </DocumentsDrawer>
    ) : (
        <DocumentsPopup visible={isBlockVisible} onClose={onClose}>
            {content}
        </DocumentsPopup>
    );

    return <>{mainElement}</>;
};

Registration.propTypes = {
    isPhone: PropTypes.bool.isRequired,
    isBlockVisible: PropTypes.bool.isRequired,
    scopeRef: PropTypes.object.isRequired,
    onClose: PropTypes.func.isRequired
};
