import {connect} from 'react-redux';

import {Documents} from './Documents';

const mapStateToProps = function(state = {}) {
    const {
        person: {language, havePassword, login, uid},
        settings: {ua: {isMobile, isTouch, isTablet, BrowserName}} = {}
    } = state;

    return {
        userUid: uid,
        language,
        isPhone: (isMobile || isTouch) && !isTablet,
        isYaApp: BrowserName === 'YandexSearch',
        /**
         * Если у пользователя нет логина или пароля, помечаем необходимость дорегистрации.
         * @see https://wiki.yandex-team.ru/disk/auth/
         */
        isRegisterRequired: login === '' || havePassword === false
    };
};

const ConnectedDocuments = connect(mapStateToProps)(Documents);

export {ConnectedDocuments as Documents};
