import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {replace} from 'connected-react-router';
import {changeEmailsState, EMAILS_GOAL_PREFIX, EMAILS_URLS} from '../actions';
import AddEmail from './add_email.jsx';
import metrics from '../../../metrics.js';

class AddEmailPage extends Component {
    componentDidMount() {
        const {emails, states} = this.props.emails;

        let haveUnconfirmed = false;

        if (states.length === 0) {
            Object.keys(emails).forEach((emailName) => {
                const email = emails[emailName];

                if (email.category === 'for_restore' && !email.confirmed) {
                    haveUnconfirmed = true;
                }
            });
            if (haveUnconfirmed) {
                this.props.dispatch(replace(EMAILS_URLS.list));
            } else {
                metrics.goal(`${EMAILS_GOAL_PREFIX}_add_open`);
                this.props.dispatch(changeEmailsState('add-initial'));
            }
        }
    }

    render() {
        const props = this.props;
        const ua = props.settings.ua;
        const isMobile = ((ua.isMobile || ua.isTouch) && !ua.isTablet) || false;
        const emailStates = props.emails.states;
        const state = emailStates[emailStates.length - 1] || null;
        const {error, loading, addedEmail} = props.emails;
        const retpath = props.common.retpath;
        const dispatch = props.dispatch;

        return (
            <AddEmail
                person={props.person}
                retpath={retpath}
                isMobile={isMobile}
                modal={false}
                dispatch={dispatch}
                error={error}
                loading={loading}
                addedEmail={addedEmail}
                addEmailState={state}
            />
        );
    }
}

AddEmailPage.propTypes = {
    person: PropTypes.object.isRequired,
    dispatch: PropTypes.func.isRequired,
    emails: PropTypes.object.isRequired,
    settings: PropTypes.shape({
        ua: PropTypes.shape({
            isMobile: PropTypes.bool,
            isTouch: PropTypes.bool,
            isTablet: PropTypes.bool
        }).isRequired
    }).isRequired,
    common: PropTypes.shape({
        retpath: PropTypes.string
    }).isRequired
};

export default AddEmailPage;
