import React, {Component} from 'react';
import PropTypes from 'prop-types';
import ReactDOM from 'react-dom';

class Collapse extends Component {
    constructor(props) {
        super(props);
        this.height = 'auto';
    }

    componentDidMount() {
        const calcBlock = document.createElement('div');

        calcBlock.style.cssText = 'position: fixed; top: 20000px; left: 20000px;';
        ReactDOM.render(this.props.children, calcBlock, () => {
            document.body.appendChild(calcBlock);
            this.calcBlock = calcBlock;
            this.height = calcBlock.getBoundingClientRect().height;
        });
    }

    render() {
        const {children, isOpen, duration, timeFunc} = this.props;
        const collapsableStyles = {
            overflow: 'hidden',
            height: isOpen ? this.height : 0,
            transition: `height ${duration}s ${timeFunc}`
        };

        return <div style={collapsableStyles}>{children}</div>;
    }
}

Collapse.defaultProps = {
    duration: 0.3,
    timeFunc: 'ease-in'
};

Collapse.propTypes = {
    isOpen: PropTypes.bool.isRequired,
    duration: PropTypes.number,
    timeFunc: PropTypes.string,
    children: PropTypes.element.isRequired
};

export default Collapse;
