import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {changeEmailsState, EMAILS_GOAL_PREFIX} from '../actions';
import EmailsList from './emails_list.jsx';
import metrics from '../../../metrics.js';

class EmailsListPage extends Component {
    componentDidMount() {
        if (this.props.emails.states.length === 0) {
            this.props.dispatch(changeEmailsState('list-initial'));
            metrics.goal(`${EMAILS_GOAL_PREFIX}_list_open`);
        }
    }

    prepareEmails(emails) {
        let haveEmails = false;
        const formattedEmails = {
            forRestore: [],
            forNotifications: [],
            rpop: [],
            other: [],
            native: []
        };

        Object.keys(emails).forEach((emailName) => {
            const email = emails[emailName];

            email.name = emailName;
            switch (email.category) {
                case 'for_restore':
                    formattedEmails.forRestore.push(email);
                    haveEmails = true;
                    break;
                case 'for_notifications':
                    formattedEmails.forNotifications.push(email);
                    haveEmails = true;
                    break;
                case 'other':
                    formattedEmails.other.push(email);
                    haveEmails = true;
                    break;
                case 'rpop':
                    formattedEmails.rpop.push(email);
                    haveEmails = true;
                    break;
                case 'native':
                    formattedEmails.native.push(email);
                    haveEmails = true;
                    break;
                default:
                    formattedEmails.other.push(email);
            }
        });

        return {
            emails: formattedEmails,
            haveEmails
        };
    }

    render() {
        const props = this.props;
        const {error, loading, states, deleteRequestEmail, selectedEmail, openAliasesList} = props.emails;
        const {emails, haveEmails} = this.prepareEmails(props.emails.emails);
        const lastState = states[states.length - 1] || null;
        const {isMobile, isTablet} = props.settings.ua;
        const retpath = props.common.retpath;
        const dispatch = props.dispatch;
        const tld = props.settings.tld;

        return (
            <EmailsList
                isLite={props.settings.isLite}
                modal={false}
                isMobile={isMobile}
                isTablet={isTablet}
                openAliasesList={openAliasesList}
                selectedEmail={selectedEmail}
                deleteRequestEmail={deleteRequestEmail}
                lastState={lastState}
                tld={tld}
                retpath={retpath}
                error={error}
                emails={emails}
                haveEmails={haveEmails}
                loading={loading}
                dispatch={dispatch}
                person={props.person}
            />
        );
    }
}

EmailsListPage.propTypes = {
    access: PropTypes.object.isRequired,
    dispatch: PropTypes.func.isRequired,
    emails: PropTypes.object.isRequired,
    settings: PropTypes.shape({
        ua: PropTypes.shape({
            isMobile: PropTypes.bool,
            isTablet: PropTypes.bool
        }),
        tld: PropTypes.string,
        isLite: PropTypes.bool
    }),
    common: PropTypes.shape({
        retpath: PropTypes.string
    }),
    person: PropTypes.object
};

export default EmailsListPage;
