import React, {Component} from 'react';
import PropTypes from 'prop-types';
import Link from '@blocks/morda/components/link/link.jsx';

class MoreEmailsLink extends Component {
    render() {
        const {count, url, limit, sectionId} = this.props;
        const more = count > limit ? count - 1 : count - limit;
        const linkText = i18n(
            {
                count: more,
                one: 'Profile.emails.more.one',
                some: 'Profile.emails.more.some',
                many: 'Profile.emails.more.many',
                none: ''
            },
            more
        );
        const testId = 'emails-more';

        if (more <= 0) {
            return null;
        }

        return (
            <div className='p-control-link'>
                <span data-t={`${testId}:${sectionId}`} onMouseDown={this.props.sendMetrics}>
                    <Link onClick={this.props.onClick} url={url}>
                        {linkText}
                    </Link>
                </span>
            </div>
        );
    }
}

MoreEmailsLink.propTypes = {
    count: PropTypes.number.isRequired,
    limit: PropTypes.number.isRequired,
    onClick: PropTypes.func.isRequired,
    sendMetrics: PropTypes.func.isRequired,
    url: PropTypes.string.isRequired,
    sectionId: PropTypes.string.isRequired
};

export default MoreEmailsLink;
