import {
    GET_EMAILS,
    GET_EMAILS_SUCCESS,
    GET_EMAILS_ERROR,
    DELETE_EMAIL,
    DELETE_EMAIL_SUCCESS,
    DELETE_EMAIL_ERROR,
    SEND_CONFIRMATION_EMAIL,
    SEND_CONFIRMATION_EMAIL_SUCCESS,
    SEND_CONFIRMATION_EMAIL_ERROR,
    RESEND_CONFIRMATION_EMAIL,
    RESEND_CONFIRMATION_EMAIL_SUCCESS,
    RESEND_CONFIRMATION_EMAIL_ERROR,
    CONFIRM_EMAIL_BY_CODE,
    CONFIRM_EMAIL_BY_CODE_SUCCESS,
    CONFIRM_EMAIL_BY_CODE_ERROR,
    EMAIL_SET_SAFE_SUCCESS,
    SET_EMAIL_ERROR,
    CHANGE_EMAILS_STATE,
    TOGGLE_ALIASES_LIST,
    TOGGLE_EMAIL_SELECTION,
    SHOW_EMAIL_DELETE_REQUEST_POPUP,
    EMAILS_STATES
} from './actions';

const INITIAL_STATE = {
    openAliasesList: false,
    selectedEmail: null
};

export default function emails(state = INITIAL_STATE, action) {
    switch (action.type) {
        case GET_EMAILS:
            return $.extend({}, state, {
                loading: 'widget'
            });
        case GET_EMAILS_SUCCESS:
            return $.extend({}, state, {
                loading: null,
                emails: action.emails
            });
        case GET_EMAILS_ERROR:
            return $.extend({}, state, {
                loading: null,
                error: action.error
            });
        case DELETE_EMAIL: {
            return $.extend({}, state, {
                loading: 'deleteEmail'
            });
        }
        case DELETE_EMAIL_SUCCESS: {
            // const converts to var and moves to the top of func
            // eslint-disable-next-line no-shadow
            const emails = $.extend({}, state.emails);

            delete emails[action.email];
            return $.extend({}, state, {
                emails,
                deleteRequestEmail: ''
            });
        }
        case DELETE_EMAIL_ERROR: {
            const newState = {
                loading: null
            };
            const alreadyDeletedError = action.errors.find((err) => err === 'email.not_found');

            if (alreadyDeletedError) {
                // eslint-disable-next-line no-shadow
                const emails = $.extend({}, state.emails);

                newState.emails = emails;
                delete emails[action.email];
                newState.emails = emails;
            }
            return $.extend({}, state, newState);
        }
        case SEND_CONFIRMATION_EMAIL: {
            return $.extend({}, state, {
                loading: 'email'
            });
        }
        case SEND_CONFIRMATION_EMAIL_SUCCESS: {
            const states = state.states.concat(EMAILS_STATES.sent);

            return $.extend({}, state, {
                states,
                loading: null,
                emails: action.emails,
                addedEmail: action.email
            });
        }
        case SEND_CONFIRMATION_EMAIL_ERROR: {
            return $.extend({}, state, {
                loading: null,
                error: (action.errors && action.errors[0]) || 'email.other'
            });
        }
        case RESEND_CONFIRMATION_EMAIL: {
            return $.extend({}, state, {
                loading: 'email'
            });
        }
        case RESEND_CONFIRMATION_EMAIL_SUCCESS: {
            return $.extend({}, state, {
                loading: null
            });
        }
        case RESEND_CONFIRMATION_EMAIL_ERROR: {
            return $.extend({}, state, {
                loading: null,
                error: (action.errors && action.errors[0]) || 'email.other'
            });
        }
        case CONFIRM_EMAIL_BY_CODE: {
            return $.extend({}, state, {
                loading: 'code'
            });
        }
        case CONFIRM_EMAIL_BY_CODE_SUCCESS: {
            const states = state.states.concat(EMAILS_STATES.confirmed);

            return $.extend({}, state, {
                loading: null,
                emails: action.emails,
                states
            });
        }
        case EMAIL_SET_SAFE_SUCCESS: {
            return $.extend({}, state, {
                loading: null,
                emails: action.emails
            });
        }
        case CONFIRM_EMAIL_BY_CODE_ERROR: {
            return $.extend({}, state, {
                loading: null,
                error: (action.errors && action.errors[0]) || 'email.other'
            });
        }
        case SET_EMAIL_ERROR: {
            return $.extend({}, state, {
                error: action.error
            });
        }
        case TOGGLE_ALIASES_LIST: {
            return $.extend({}, state, {
                openAliasesList: !state.openAliasesList
            });
        }
        case TOGGLE_EMAIL_SELECTION: {
            return $.extend({}, state, {
                selectedEmail: action.email
            });
        }
        case SHOW_EMAIL_DELETE_REQUEST_POPUP: {
            return $.extend({}, state, {
                selectedEmail: action.email,
                deleteRequestEmail: action.email
            });
        }
        case CHANGE_EMAILS_STATE: {
            let states;
            const emailStates = state.states;
            const isInitial = action.state.match(/(\w*)-initial/);

            // If user closed popup on sent state,
            // we'll show it as initial state next time
            if (isInitial) {
                states = [isInitial[1]];
            } else if (action.state === EMAILS_STATES.root) {
                states = [emailStates[0]];
            } else {
                states = emailStates.concat(action.state);
            }

            return $.extend({}, state, {
                error: null,
                loading: null,
                states
            });
        }
        default:
            return state;
    }
}
