import React from 'react';
import {push} from 'react-router-redux';

import {Link} from '@components/Link';

import {setEditMode} from '../../../common/actions';
import {
    EDIT_MODE_ADDRESSES,
    EDIT_MODE_DELIVERY_ADDRESSES,
    ADDRESSES_LINK,
    setAddressesEditMode
} from '../../addresses/actions';

/* eslint-disable no-invalid-this */

export function getAddressLink(text, onClick) {
    return (
        <Link pseudo={!this.isTouch} href={this.isTouch ? ADDRESSES_LINK : undefined} onClick={onClick}>
            {text}
        </Link>
    );
}

export function showAddresses(e = {}) {
    if (e.preventDefault) {
        e.preventDefault();
    }

    this.setEditMode(EDIT_MODE_ADDRESSES);
}

export function showDeliveryAddresses(e = {}) {
    if (e.preventDefault) {
        e.preventDefault();
    }

    this.setEditMode(EDIT_MODE_DELIVERY_ADDRESSES);
}

export function setMode(mode) {
    const {dispatch} = this.props;

    dispatch(setAddressesEditMode(mode));
    if (!this.isTouch) {
        dispatch(setEditMode(mode));
    } else {
        dispatch(push(ADDRESSES_LINK));
    }
}
