import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';

export default function Arrow({direction, onClick, hidden}) {
    return (
        <div
            className={classnames(`p-arrow p-arrow__${direction} p-arrow__click-scale`, {
                'p-arrow__hidden': hidden
            })}
            onClick={() => onClick(direction)}
        >
            <svg className='passport-Icon-SVG'>
                <use xlinkHref={`#Icon_arrow_${direction}_black`} />
            </svg>
        </div>
    );
}

Arrow.propTypes = {
    direction: PropTypes.oneOf(['left', 'right']).isRequired,
    hidden: PropTypes.bool.isRequired,
    onClick: PropTypes.func.isRequired
};

Arrow.defaultProps = {
    hidden: false,
    direction: 'right'
};
