import React from 'react';
import PropTypes from 'prop-types';
import {countAppPasswords} from '@blocks/morda/app_passwords';

import {Spin} from '@components/Spin';

import Passwords from './passwords.jsx';
import CreateAppPassword from './create_app_password.jsx';

export default class AppPasswords extends React.Component {
    constructor(props) {
        super(props);

        const state = {
            loading: false
        };

        if (typeof window !== 'undefined' && this.props.access.isAppPasswordsEnabled) {
            state.loading = true;

            this.props.dispatch(countAppPasswords(() => this.setState({loading: false})));
        }

        this.state = state;
    }

    render() {
        const {dispatch, edit, retpath, access, settings, appPasswords, isSocialchik, isFederal} = this.props;
        const appPasswordsCount = appPasswords.tokens.appPasswordsCount || 0;

        return (
            <div data-t='pssp:app_passwords'>
                <div className='s-block__sub s-block__sub_hl'>
                    <Passwords
                        edit={edit}
                        settings={settings}
                        is2faEnabled={access.is2faEnabled}
                        isFederal={isFederal}
                        passwordStrength={access.passwordInfo.strength}
                        featureHint={access.featureHint}
                        isEnabled={access.isAppPasswordsEnabled}
                        appPasswords={appPasswords}
                        retpath={retpath}
                        dispatch={dispatch}
                    />
                </div>
                {access.isAppPasswordsEnabled ? (
                    <div>
                        <div className='s-block__sub'>
                            {this.state.loading && (
                                <div data-t='pssp:app_passwords_count_loading'>
                                    <Spin progress={true} size='xxs' />
                                </div>
                            )}
                            {!this.state.loading && (
                                <div data-t='pssp:app_passwords_count'>
                                    {appPasswordsCount
                                        ? i18n(
                                              {
                                                  count: appPasswordsCount,
                                                  one: 'Profile2.app_passes.passes.one',
                                                  some: 'Profile2.app_passes.passes.some',
                                                  many: 'Profile2.app_passes.passes.many',
                                                  none: ''
                                              },
                                              appPasswordsCount
                                          )
                                        : i18n('Profile2.app_passes.no_passes')}
                                </div>
                            )}
                        </div>
                        <div className='s-block__sub'>
                            <CreateAppPassword
                                appPasswords={appPasswords}
                                isAppPasswordsEnabled={access.isAppPasswordsEnabled}
                                dispatch={dispatch}
                                isSocialchik={isSocialchik}
                                edit={edit}
                                retpath={retpath}
                                settings={settings}
                            />
                        </div>
                    </div>
                ) : (
                    <div className='s-block__sub'>{i18n('Profile2.safe_password')}</div>
                )}
            </div>
        );
    }
}

AppPasswords.propTypes = {
    dispatch: PropTypes.func.isRequired,
    edit: PropTypes.string,
    retpath: PropTypes.string.isRequired,
    access: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired,
    appPasswords: PropTypes.object.isRequired,
    isSocialchik: PropTypes.bool.isRequired,
    isFederal: PropTypes.bool.isRequired
};
