import React from 'react';
import PropTypes from 'prop-types';

import {Link} from '@components/Link';
import Modal from '@components/Wrappers/Modal.jsx';

import {CreateAppPasswordBlock} from '@blocks/morda/create_app_passwords/create_app_passwords_block.jsx';

import * as extracted from './create_app_password.js';

export default class CreateAppPassword extends React.PureComponent {
    constructor(props) {
        super(props);

        this.showCreationPopup = extracted.showCreationPopup.bind(this);
    }

    render() {
        const {settings, dispatch, edit, appPasswords, isAppPasswordsEnabled} = this.props;

        return (
            <div data-t={`pssp:create_app_password_${appPasswords.tokens.appPasswordsCount ? 'more' : 'first'}`}>
                <Link pseudo={true} onClick={this.showCreationPopup}>
                    {appPasswords.tokens.appPasswordsCount
                        ? i18n('Profile2.app_passes.create_one_more')
                        : i18n('Profile.access.create-apppwd')}
                </Link>
                {!settings.isTouch && (
                    <Modal visible={edit === 'apppwd-create'} zIndexGroupLevel={-0.5} dataT='create-app-password'>
                        {edit === 'apppwd-create' && (
                            <CreateAppPasswordBlock
                                modal={true}
                                edit={edit}
                                isPhone={settings.isPhone}
                                appPasswords={appPasswords}
                                isAppPasswordsEnabled={isAppPasswordsEnabled}
                                dispatch={dispatch}
                                settings={settings}
                            />
                        )}
                    </Modal>
                )}
            </div>
        );
    }
}

CreateAppPassword.propTypes = {
    appPasswords: PropTypes.object.isRequired,
    isAppPasswordsEnabled: PropTypes.bool.isRequired,
    dispatch: PropTypes.func.isRequired,
    isSocialchik: PropTypes.bool.isRequired,
    edit: PropTypes.string,
    retpath: PropTypes.string,
    settings: PropTypes.object.isRequired
};
