import {push} from 'react-router-redux';

import {setEditMode, showRegPopup} from '@blocks/common/actions';
import {showHint} from '@blocks/morda/access/actions';
import {getTokensList} from '@blocks/morda/app_passwords/index';

/* eslint-disable no-invalid-this */

export function showAppPasswordsModal() {
    const {
        dispatch,
        appPasswords,
        settings: {isTouch}
    } = this.props;

    if (isTouch) {
        this.redirectToAppPasswordsList();
        return;
    }

    if (appPasswords.tokens.appPasswordsCount > 0) {
        dispatch(getTokensList());
    }

    dispatch(setEditMode('apppasswords-list'));
}

export function redirectToAppPasswordsList() {
    const {retpath, dispatch} = this.props;

    let redirectUrl = '/profile/apppasswords-list';

    if (retpath) {
        redirectUrl += `?retpath=${encodeURIComponent(retpath)}`;
    }

    dispatch(push(redirectUrl));
}

export function onLinkClick() {
    const {
        passwordStrength,
        dispatch,
        is2faEnabled,
        isFederal,
        settings: {isTouch}
    } = this.props;

    if (passwordStrength === -1 && !is2faEnabled && !isFederal) {
        dispatch(showRegPopup(true));
        return;
    }

    if (isTouch) {
        this.redirectToAppPasswordsList();
        return;
    }

    dispatch(setEditMode('apppasswords-list'));
    dispatch(showHint(''));
}
