import React from 'react';
import classNames from 'classnames';
import PropTypes from 'prop-types';

import {Section} from '@blocks/morda/new/section/section.jsx';
import PassAndKVKO from './pass_and_kvko/pass_and_kvko.jsx';
import {EnterWithoutPassword} from './without_password/without_password.jsx';
import AppPasswords from './app_passwords/app_passwords.jsx';
import TwoFA from './twofa.jsx';
import {LoginMethodModal} from '@blocks/LoginMethod/LoginMethodModal';
import {PhoneBindConfirmModal} from '@blocks/Screens/PhoneBindConfirm/PhoneBindConfirmModal';
import {hasExp} from '@blocks/selectors';

import {withUpdater} from '../../../hocs/withContext';

export class AuthBlock extends React.Component {
    render() {
        const {
            dispatch,
            common,
            access,
            security,
            settings,
            appPasswords,
            person,
            captcha,
            hasPhone,
            hasAliasPhone,
            phoneNumber
        } = this.props;
        const {passwordInfo = {}} = access;
        const isStrongPolicyOn = passwordInfo.strong_policy_on;
        const {experiments} = common;
        const {loginOptions, isFederal} = person;
        const {isPhone} = settings;
        const isShowNoPasswordSettingsExp = (experiments.flags || []).includes('settings-nopassword-on');
        const showEnterWithoutPassword = !access.is2faEnabled && person.havePassword;

        return (
            <Section className='p-auth' icon='key' title={i18n('Profile2.titles.passes_auth')} isHiddenDefault={true}>
                {hasExp({common}, 'auth_params_exp') && (
                    <div className='s-block s-block__margin'>
                        <LoginMethodModal dispatch={dispatch} />
                        <PhoneBindConfirmModal editModeOnSuccess='loginMethod' place='profileAuthBlock' />
                    </div>
                )}
                {showEnterWithoutPassword && isShowNoPasswordSettingsExp && (
                    <div className='s-block s-block__margin'>
                        <EnterWithoutPassword
                            isStrongPolicyOn={isStrongPolicyOn}
                            loginOptions={loginOptions}
                            phoneNumber={phoneNumber}
                            hasPhone={hasPhone}
                            hasAliasPhone={hasAliasPhone}
                            dispatch={dispatch}
                            isPhone={isPhone}
                        />
                    </div>
                )}
                {(!access.is2faEnabled || !isStrongPolicyOn) && (
                    <div className='s-block s-block__margin'>
                        <PassAndKVKO
                            showUserQuestion={!isStrongPolicyOn}
                            login={person.login}
                            dispatch={dispatch}
                            common={common}
                            access={access}
                            settings={settings}
                            captcha={captcha}
                            security={security}
                        />
                    </div>
                )}
                <div
                    className={classNames(
                        's-block',
                        's-block__margin',
                        showEnterWithoutPassword && isShowNoPasswordSettingsExp && 's-block__margin_last-m'
                    )}
                >
                    <AppPasswords
                        dispatch={dispatch}
                        edit={common.edit}
                        retpath={common.retpath || ''}
                        access={access}
                        isFederal={isFederal}
                        settings={settings}
                        appPasswords={appPasswords}
                        isSocialchik={person.isSocialchik}
                    />
                </div>
                <div className='s-block'>
                    <TwoFA
                        is2faEnabled={access.is2faEnabled}
                        canChangePassword={common.canChangePassword}
                        passwordStrength={access.passwordInfo.strength}
                        dispatch={dispatch}
                        edit={common.edit}
                    />
                </div>
            </Section>
        );
    }
}

AuthBlock.propTypes = {
    dispatch: PropTypes.func.isRequired,
    common: PropTypes.object.isRequired,
    access: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired,
    security: PropTypes.object.isRequired,
    appPasswords: PropTypes.object.isRequired,
    captcha: PropTypes.object.isRequired,
    person: PropTypes.object.isRequired,
    hasAliasPhone: PropTypes.bool,
    hasPhone: PropTypes.bool,
    phoneNumber: PropTypes.string
};

export default withUpdater(
    AuthBlock,
    ['apppasswords-list', 'apppwd-create', 'twofaErrorModal', 'loginMethod'],
    'common.edit',
    true
);
