import {showRegPopup} from '../../../../common/actions';
import {push} from 'react-router-redux';

/* eslint-disable no-invalid-this */

export function pushToPasswordPage() {
    this.props.dispatch(push('/profile/password'));
}

export function onYaTeamModalConfirm() {
    this.props.settings.isPhone
        ? pushToPasswordPage.call(this)
        : this.setState({
              isEditModalOpened: true,
              isYaTeamWarningModalOpened: false
          });
}

export function changePassword() {
    const {
        passwordStrength,
        canChangePassword,
        dispatch,
        isIntranet,
        settings: {isPhone}
    } = this.props;

    if (canChangePassword !== undefined && !canChangePassword) {
        this.setState({isModalOpened: true});
    } else if (passwordStrength === -1) {
        dispatch(showRegPopup(true));
    } else if (isPhone && !isIntranet) {
        pushToPasswordPage.call(this);
    } else {
        this.setState({[isIntranet ? 'isYaTeamWarningModalOpened' : 'isEditModalOpened']: true});
    }
}
