import React from 'react';
import PropTypes from 'prop-types';

import {Link} from '@components/Link';
import Modal from '@components/Wrappers/Modal.jsx';
import Password, {STAFF_LINK} from '@blocks/morda/new/forms/password/password.jsx';
import ModalTitle from '@blocks/morda_intranet/components/modal/title/modal_title.jsx';
import ModalMessage from '@blocks/morda_intranet/components/modal/message/modal_message.jsx';
import ModalActions from '@blocks/morda_intranet/components/modal/actions/modal_actions.jsx';

import metrics from '@blocks/metrics';

import * as extracted from './change_password.js';

export default class ChangePassword extends React.PureComponent {
    static sendMetrics() {
        metrics.send(['Безопасность аккаунта', 'Сменить пароль']);
    }

    constructor() {
        super();

        this.state = {
            isModalOpened: false,
            isEditModalOpened: false,
            isYaTeamWarningModalOpened: false
        };
        this.onYaTeamModalConfirm = extracted.onYaTeamModalConfirm.bind(this);
        this.changePassword = extracted.changePassword.bind(this);
        this.closeErrorModal = () => this.setState({isModalOpened: false});
        this.closeEditModal = () => this.setState({isEditModalOpened: false, isYaTeamWarningModalOpened: false});
    }

    render() {
        const {
            login,
            dispatch,
            settings: {staticPath, language, isPhone, ua},
            isStrongPolicyOn,
            isIntranet,
            captcha,
            retpath
        } = this.props;
        const {isModalOpened, isEditModalOpened, isYaTeamWarningModalOpened} = this.state;
        const isMobileCaptcha = Boolean(ua.isMobile || ua.isTablet);

        return (
            <span data-t='pssp:change_password'>
                <span onClick={ChangePassword.sendMetrics}>
                    <Link pseudo={true} onClick={this.changePassword}>
                        {i18n('_AUTH_.changePassword')}
                    </Link>
                </span>
                <Modal
                    visible={isModalOpened}
                    zIndexGroupLevel={-0.5}
                    onCloserClick={this.closeErrorModal}
                    dataT='change-password-error'
                >
                    <div className='section-head'>
                        <h2 className='section-title'>{i18n('Errors.password.change.forbidden')}</h2>
                    </div>
                    <div className='p-control-modal-message'>{i18n('_AUTH_.restore_domain_not_served')}</div>
                </Modal>
                {(!isPhone || isIntranet) && (
                    <Modal
                        visible={isEditModalOpened || isYaTeamWarningModalOpened}
                        onCloserClick={this.closeEditModal}
                        dataT='change-password'
                    >
                        {isYaTeamWarningModalOpened && (
                            <div className='p-control-form'>
                                <ModalTitle>{i18n('Frontend.title.changepassword')}</ModalTitle>
                                <ModalMessage>
                                    <div
                                        dangerouslySetInnerHTML={{
                                            __html: i18n('Profile2.intranet.disclaimer').replace('%href%', STAFF_LINK)
                                        }}
                                    />
                                </ModalMessage>
                                <ModalActions
                                    cancel={{
                                        onClick: this.closeEditModal
                                    }}
                                    confirm={{
                                        onClick: this.onYaTeamModalConfirm
                                    }}
                                />
                            </div>
                        )}
                        {isEditModalOpened && (
                            <Password
                                login={login}
                                isModal={true}
                                dispatch={dispatch}
                                staticPath={staticPath}
                                language={language}
                                captcha={captcha}
                                retpath={retpath}
                                isIntranet={isIntranet}
                                isMobileCaptcha={isMobileCaptcha}
                                isStrongPolicyOn={isStrongPolicyOn}
                                closeModal={this.closeEditModal}
                            />
                        )}
                    </Modal>
                )}
            </span>
        );
    }
}

ChangePassword.propTypes = {
    isIntranet: PropTypes.bool,
    login: PropTypes.string.isRequired,
    dispatch: PropTypes.func.isRequired,
    passwordStrength: PropTypes.number.isRequired,
    isStrongPolicyOn: PropTypes.bool.isRequired,
    captcha: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired,
    retpath: PropTypes.string
};
