import React from 'react';
import PropTypes from 'prop-types';

import ChangePassword from './change_password.jsx';
import UserQuestion from './user_question.jsx';

export default function PassAndKVKO({dispatch, common, access, settings, security, captcha, login, showUserQuestion}) {
    return (
        <div data-t='pssp:pass_and_kvko'>
            <div className='s-block__sub s-block__sub_hl'>
                {!access.is2faEnabled && (
                    <ChangePassword
                        login={login}
                        dispatch={dispatch}
                        captcha={captcha}
                        settings={settings}
                        retpath={common.retpath}
                        canChangePassword={common.canChangePassword}
                        isStrongPolicyOn={access.passwordInfo.strong_policy_on}
                        passwordStrength={access.passwordInfo.strength}
                    />
                )}
                {!access.is2faEnabled && showUserQuestion && <span> {i18n('Frontend.suggest_or')} </span>}
                {showUserQuestion && (
                    <UserQuestion
                        common={common}
                        settings={settings}
                        access={access}
                        security={security}
                        dispatch={dispatch}
                    />
                )}
            </div>
            {access.passwordInfo.timeFromUpdate && (
                <div className='s-block__sub'>
                    {i18n('Profile2.last_pass_change')} {access.passwordInfo.timeFromUpdate}
                </div>
            )}
        </div>
    );
}

PassAndKVKO.propTypes = {
    showUserQuestion: PropTypes.bool.isRequired,
    login: PropTypes.string.isRequired,
    dispatch: PropTypes.func.isRequired,
    common: PropTypes.object.isRequired,
    access: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired,
    captcha: PropTypes.object.isRequired,
    security: PropTypes.object.isRequired
};
