import React from 'react';
import PropTypes from 'prop-types';
import {push} from 'react-router-redux';

import Modal from '@components/Wrappers/Modal.jsx';
import {Link} from '@components/Link';

import KvKoModal from '@blocks/morda/security/user_question/modal.jsx';

import {showKvKo} from '@blocks/morda/security/user_question/actions';
import {showRegPopup} from '@blocks/common/actions';

import withContext from '@blocks/hocs/withContext';
import metrics from '@blocks/metrics';

const changeHintUrl = '/profile/change-hint';
const TEXTS = {
    ADD: i18n('Profile2.security_question.add'),
    CHANGE: i18n('Profile2.security_question.change'),
    ADD_UPPER: i18n('Profile2.security_question.add_upper'),
    QUESTION: i18n('Profile2.security_question')
};

export class UserQuestion extends React.Component {
    static sendMetrics() {
        metrics.send(['Изменить контрольный вопрос/ответ', 'Открыть форму']);
    }

    constructor(props) {
        super(props);

        this.showKvKoModal = this.showKvKoModal.bind(this);
    }

    shouldComponentUpdate(nextProps) {
        return nextProps.context.rerender === 'all';
    }

    showKvKoModal(event) {
        const {
            settings: {isTouch},
            access,
            dispatch
        } = this.props;

        event.preventDefault();

        if (access.passwordInfo.strength === -1 && !access.is2faEnabled) {
            dispatch(showRegPopup(true));
        } else if (isTouch) {
            dispatch(push(changeHintUrl));
        } else {
            dispatch(showKvKo(true));
        }
    }

    render() {
        const {
            security,
            settings,
            common,
            dispatch,
            access: {is2faEnabled}
        } = this.props;
        const {
            controlQuestion: {visible, current}
        } = security;
        const text = is2faEnabled
            ? `${!current ? TEXTS.ADD_UPPER : TEXTS.CHANGE} ${TEXTS.QUESTION}`
            : `${!current ? `${TEXTS.ADD} ` : ''}${TEXTS.QUESTION}`;

        return (
            <span data-t='pssp:user_question'>
                <span onClick={UserQuestion.sendMetrics}>
                    <Link href={changeHintUrl} onClick={this.showKvKoModal}>
                        {text}
                    </Link>
                </span>
                <Modal visible={visible} cls='profile__modal-z' dataT='user-question'>
                    <KvKoModal
                        security={security}
                        settings={settings}
                        dispatch={dispatch}
                        common={common}
                        modal={true}
                    />
                </Modal>
            </span>
        );
    }
}

UserQuestion.propTypes = {
    dispatch: PropTypes.func.isRequired,
    settings: PropTypes.object.isRequired,
    access: PropTypes.object.isRequired,
    common: PropTypes.object.isRequired,
    security: PropTypes.object.isRequired,
    context: PropTypes.object.isRequired
};

export default withContext(UserQuestion);
