import {showRegPopup, setEditMode} from '../../../common/actions';

/* eslint-disable no-invalid-this */

export const TWOFA_ERROR_MODAL = 'twofaErrorModal';

export function closeErrorModal() {
    this.props.dispatch(setEditMode(null));
}

export function onLinkClick(event) {
    const {passwordStrength, dispatch, canChangePassword, is2faEnabled} = this.props;

    if (canChangePassword !== undefined && !canChangePassword) {
        dispatch(setEditMode(TWOFA_ERROR_MODAL));
    } else if (passwordStrength === -1 && !is2faEnabled) {
        dispatch(showRegPopup(true));
    } else {
        return;
    }

    event.preventDefault();
}
