import React from 'react';
import PropTypes from 'prop-types';

import {Link} from '@components/Link';
import Modal from '@components/Wrappers/Modal.jsx';

const ENABLE_LINK = '/profile/access/2fa?origin=passport_profile';
const DISABLE_LINK = '/profile/access/2fa/disable?origin=passport_profile';
const MIGRATE_LINK = '/profile/access/2fa/migrate';

import * as extracted from './twofa.js';

export default class TwoFA extends React.PureComponent {
    constructor(props) {
        super(props);

        this.onLinkClick = extracted.onLinkClick.bind(this);
        this.closeErrorModal = extracted.closeErrorModal.bind(this);
    }

    render() {
        const {is2faEnabled, edit} = this.props;

        return (
            <div data-t='pssp:twofa'>
                <div className='s-block__sub s-block__sub_hl'>
                    <Link
                        href={is2faEnabled ? MIGRATE_LINK : ENABLE_LINK}
                        onClick={is2faEnabled ? undefined : this.onLinkClick}
                    >
                        {is2faEnabled ? i18n('Profile2.change_twofa_device') : i18n('Profile.twofa.enable')}
                    </Link>
                </div>
                <div className='s-block__sub'>
                    {is2faEnabled ? (
                        <Link href={DISABLE_LINK} onClick={this.onLinkClick}>
                            {i18n('Profile2.twofa.close')}
                        </Link>
                    ) : (
                        <span>{i18n('Profile2.auth_no_pass')}</span>
                    )}
                </div>
                <Modal
                    visible={edit === extracted.TWOFA_ERROR_MODAL}
                    zIndexGroupLevel={-0.5}
                    onCloserClick={this.closeErrorModal}
                    dataT='twofa'
                >
                    <div className='section-head'>
                        <h2 className='section-title'>{i18n('Errors.2fa.unavailable')}</h2>
                    </div>
                    <div className='p-control-modal-message'>{i18n('Mend.2fa.unavailable.message')}</div>
                </Modal>
            </div>
        );
    }
}

TwoFA.propTypes = {
    is2faEnabled: PropTypes.bool.isRequired,
    canChangePassword: PropTypes.bool,
    passwordStrength: PropTypes.number,
    dispatch: PropTypes.func.isRequired,
    edit: PropTypes.string
};
