import React from 'react';
import PropTypes from 'prop-types';
import {Spin} from '@components/Spin';
import {ItemEnterWithoutPassword} from '../item_without_password.jsx';
import classnames from 'classnames';
import {toggleEnterWithoutPassword} from '@blocks/morda/personal_info/effects/enter_without_password';

export class EnterWithoutPasswordBody extends React.Component {
    getSmsLoginText() {
        const {isNewSettingsTextExp, phoneNumber, hasAliasPhone, phonesLink} = this.props;

        if (isNewSettingsTextExp) {
            if (phoneNumber) {
                if (hasAliasPhone) {
                    return i18n('Profile.sms.login_info.v2')
                        .replace('%link', phonesLink)
                        .replace('%phone', `<span class="togglePhone">${phoneNumber}</span>`);
                }
                return i18n('Profile.sms.login_alisify-phone.v2')
                    .replace('%link', phonesLink)
                    .replace('%phone', phoneNumber);
            }
            return i18n('Profile.sms.login_add-phone.v2').replace('%link', phonesLink);
        }

        return i18n('Frontend.enter_with_sms_description');
    }
    getItemsList() {
        const {isStrongPolicyOn, loginOptions, hasAliasPhone, isWebauthnNavigatorError, showWebauthn} = this.props;
        const {qrCodeLoginForbidden, smsCodeLoginForbidden} = loginOptions;

        const itemsList = [
            {
                id: 'qrCodeLoginForbidden',
                title: i18n('Frontend.qr_code_login.title'),
                description: i18n('Frontend.qr_code_login.description'),
                toggle: qrCodeLoginForbidden,
                hasToggler: true
            }
        ];

        showWebauthn &&
            itemsList.unshift({
                id: 'webauthn',
                title: i18n('Frontend.webauthn_login.title'),
                description: !isWebauthnNavigatorError
                    ? i18n('Frontend.webauthn_login.description')
                    : i18n('Frontend.webauthn_login.description.error')
            });

        !isStrongPolicyOn &&
            itemsList.push({
                id: 'smsCodeLoginForbidden',
                title: i18n('Frontend.enter_with_sms'),
                description: this.getSmsLoginText(),
                toggle: smsCodeLoginForbidden,
                disabled: !hasAliasPhone,
                hasToggler: hasAliasPhone
            });

        return itemsList;
    }
    toggleMethod = (id) => {
        const {loginOptions, dispatch} = this.props;
        const {qrCodeLoginForbidden, smsCodeLoginForbidden} = loginOptions;
        const payload = {
            qrCodeLoginForbidden,
            smsCodeLoginForbidden
        };

        payload[id] = !payload[id];

        dispatch(toggleEnterWithoutPassword(payload));
    };
    render() {
        const {isNewSettingsTextExp, place} = this.props;
        const itemsList = this.getItemsList();

        return (
            <React.Fragment>
                <h2 className='section-title'>{i18n('Frontend.magic_auth.title')}</h2>
                <div className='without-password-list_items'>
                    <div className='without-password-list_content'>
                        <div className='description-text' />
                        <span className='personal-spinner'>
                            <Spin size='s' progress={!itemsList.length} />
                        </span>
                        <div className='info-list'>
                            <div className='info-list_head'>
                                <span
                                    className={classnames({
                                        'without-password-type': true,
                                        'without-password-page': place === 'page'
                                    })}
                                >
                                    {i18n('Frontend.magic_auth.title.method')}
                                </span>
                                <span
                                    className={classnames({
                                        'without-password-state': true,
                                        'without-password-page': place === 'page'
                                    })}
                                >
                                    {i18n('Frontend.magic_auth.title.condition')}
                                </span>
                            </div>
                            <div className={classnames('info-list-wrapper')}>
                                {itemsList.map((item) => (
                                    <ItemEnterWithoutPassword
                                        {...item}
                                        key={item.id}
                                        toggleClick={this.toggleMethod}
                                        place={place}
                                        isNewSettingsTextExp={isNewSettingsTextExp}
                                    />
                                ))}
                            </div>
                        </div>
                    </div>
                </div>
            </React.Fragment>
        );
    }
}

EnterWithoutPasswordBody.propTypes = {
    loginOptions: PropTypes.shape({
        qrCodeLoginForbidden: PropTypes.bool.isRequired,
        smsCodeLoginForbidden: PropTypes.bool
    }),
    dispatch: PropTypes.func.isRequired,
    place: PropTypes.string,
    hasAliasPhone: PropTypes.bool,
    isStrongPolicyOn: PropTypes.bool,
    isNewSettingsTextExp: PropTypes.bool,
    isWebauthnNavigatorError: PropTypes.bool,
    showWebauthn: PropTypes.bool,
    phoneNumber: PropTypes.string,
    phonesLink: PropTypes.string,
    hasPhone: PropTypes.bool
};
