import {connect} from 'react-redux';
import {hasExp} from '@blocks/selectors';
import {EnterWithoutPasswordBody as Body} from './EnterWithoutPasswordBody';

const mapStateToProps = (state = {}) => {
    const {
        webauthn: {isNavigatorError = false} = {},
        phones: {restore = []} = {},
        settings: {passportLinks = {}} = {}
    } = state;

    return {
        isNewSettingsTextExp: hasExp(state, 'settings-nopassword-on-new'),
        isWebauthnNavigatorError: isNavigatorError,
        showWebauthn: hasExp(state, 'settings_nopassword_webauthn_on') && Boolean(restore.length),
        phonesLink: passportLinks.phones
    };
};

export const EnterWithoutPasswordBody = connect(mapStateToProps)(Body);
