import {connect} from 'react-redux';
import {Webauthn as WebauthnComponent} from './Webauthn';

import {fetchWebauthnCredentials, postWebauthnReg, confirmPhone, commitPhone, removeError, removeCred} from './api';

const mapStateToProps = ({webauthn = {}, phones: {restore: [securedPhone = null] = []} = {}}) => ({
    ...webauthn,
    hasSecurePhone: Boolean(securedPhone && securedPhone.id)
});

const mapDispatchToProps = {
    fetchWebauthnCredentials,
    postWebauthnReg,
    removeError,
    removeCred,
    confirmPhone,
    commitPhone
};

export const Webauthn = connect(mapStateToProps, mapDispatchToProps)(WebauthnComponent);
