import {SET_WEBAUTHN_LOADING, SET_WEBAUTHN_ERROR, SET_WEBAUTHN_LIST} from './actions';

const defaultState = {
    loading: false,
    error: null,
    list: []
};

export default function(state = defaultState, action = {}) {
    const {type, payload} = action;

    switch (type) {
        case SET_WEBAUTHN_LOADING:
            return Object.assign({}, state, {loading: payload});
        case SET_WEBAUTHN_ERROR:
            return Object.assign({}, state, {
                error: payload,
                isNavigatorError: payload === 'navigator.credentials' || state.isNavigatorError
            });
        case SET_WEBAUTHN_LIST:
            return Object.assign({}, state, {
                list: payload,
                hasSuggestedDevice: payload && payload.length && payload.some((cred) => cred.isSuggested)
            });
        default:
            return state;
    }
}
