import React, {useCallback} from 'react';
import PropTypes from 'prop-types';
import {Tumbler} from '@components/Tumbler';
import classnames from 'classnames';

import {Webauthn} from './Webauthn';

export const ItemEnterWithoutPassword = ({
    title,
    description,
    id,
    toggle,
    toggleClick,
    place,
    hasToggler,
    disabled,

    isNewSettingsTextExp
}) => {
    const toggleClickBind = useCallback(() => toggleClick(id), [id, toggleClick]);
    const isWebauthn = id === 'webauthn';

    return (
        <div
            className={classnames({
                'info-list_item': true,
                'info-list_item_webauthn': isWebauthn,
                'without-password-page': place === 'page'
            })}
            data-t={`pssp:without_password-${id}`}
        >
            <div className='method'>
                <span className='method-name'>{title}</span>
                <p className='method-description' dangerouslySetInnerHTML={{__html: description}} />
            </div>

            {isWebauthn ? (
                <Webauthn />
            ) : isNewSettingsTextExp ? (
                hasToggler && (
                    <div
                        className={classnames({
                            toggle: true,
                            'without-password-page': place === 'page'
                        })}
                    >
                        <Tumbler size='m' checked={!toggle} onChange={toggleClickBind} />
                    </div>
                )
            ) : (
                <div
                    className={classnames({
                        toggle: true,
                        'without-password-page': place === 'page'
                    })}
                >
                    <Tumbler size='m' disabled={disabled} checked={!disabled && !toggle} onChange={toggleClickBind} />
                </div>
            )}
        </div>
    );
};

ItemEnterWithoutPassword.propTypes = {
    title: PropTypes.string.isRequired,
    description: PropTypes.string.isRequired,
    place: PropTypes.string,
    id: PropTypes.string.isRequired,
    toggle: PropTypes.bool.isRequired,
    toggleClick: PropTypes.func.isRequired,
    isNewSettingsTextExp: PropTypes.bool,
    disabled: PropTypes.bool,
    hasToggler: PropTypes.bool
};
