import {push} from 'react-router-redux';

import {EDIT_MODE_NAME, CARDS_LINK} from '@blocks/morda/cards';

import binMap from './bin_map';
import {BILLING_METRICS_PREFIX, BILLING_GOAL_PREFIX} from '@blocks/morda/billing_info';
import {setEditMode} from '@blocks/common/actions';
import {selectCard} from '@blocks/morda/cards/actions';

import metrics from '@blocks/metrics';

/* eslint-disable no-invalid-this */

export function construct(props) {
    this.bank = (props.card.number && binMap[props.card.number.substring(0, 6)]) || 'light';
}

export function selectBankCard() {
    const {dispatch, card = {}, isTouch} = this.props;

    metrics.send([BILLING_METRICS_PREFIX, 'Редактировать']);
    metrics.goal(`${BILLING_GOAL_PREFIX}edit`);

    if (isTouch) {
        dispatch(push(CARDS_LINK));
    } else {
        dispatch(selectCard(card.id));
        dispatch(setEditMode(EDIT_MODE_NAME));
        metrics.send([BILLING_METRICS_PREFIX, 'Открыли попап']);
    }
}
