import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';

import {CARDS_LINK} from '@blocks/morda/cards';

import * as extracted from './bank_card.js';

import './bank_card_redesign.styl';

const b = cn('BankCard');

export default class BankCard extends React.Component {
    constructor(props) {
        super(props);

        !props.isAdd && extracted.construct.call(this, props);
    }

    selectCard = (e) => {
        const {onClick} = this.props;

        onClick && e.stopPropagation();

        extracted.selectBankCard.call(this);
    };
    renderSettingsSvg = () => (
        <div className={b('settings')}>
            <svg
                className={b('settingsSvg')}
                width='16'
                height='16'
                viewBox='0 0 16 16'
                xmlns='http://www.w3.org/2000/svg'
            >
                <path
                    fillRule='evenodd'
                    clipRule='evenodd'
                    // eslint-disable-next-line max-len
                    d='M6.5 2.5C6.5 1.67157 7.17157 1 8 1C8.82843 1 9.5 1.67157 9.5 2.5C9.5 3.32843 8.82843 4 8 4C7.17157 4 6.5 3.32843 6.5 2.5ZM6.5 8C6.5 7.17157 7.17157 6.5 8 6.5C8.82843 6.5 9.5 7.17157 9.5 8C9.5 8.82843 8.82843 9.5 8 9.5C7.17157 9.5 6.5 8.82843 6.5 8ZM8 12C7.17157 12 6.5 12.6716 6.5 13.5C6.5 14.3284 7.17157 15 8 15C8.82843 15 9.5 14.3284 9.5 13.5C9.5 12.6716 8.82843 12 8 12Z'
                />
            </svg>
        </div>
    );
    renderPlusSvg = () => (
        <div className={b('plus')}>
            <svg
                className={b('plusSvg')}
                width='28'
                height='28'
                viewBox='0 0 28 28'
                fill='none'
                xmlns='http://www.w3.org/2000/svg'
            >
                <path
                    fillRule='evenodd'
                    clipRule='evenodd'
                    // eslint-disable-next-line max-len
                    d='M25.6668 14C25.6668 20.4433 20.4435 25.6666 14.0002 25.6666C7.55684 25.6666 2.3335 20.4433 2.3335 14C2.3335 7.55666 7.55684 2.33331 14.0002 2.33331C20.4435 2.33331 25.6668 7.55666 25.6668 14ZM23.3335 14C23.3335 19.1546 19.1548 23.3333 14.0002 23.3333C8.8455 23.3333 4.66683 19.1546 4.66683 14C4.66683 8.84532 8.8455 4.66665 14.0002 4.66665C19.1548 4.66665 23.3335 8.84532 23.3335 14ZM8.16659 15.1662C7.52226 15.166 7.00003 14.6436 7.00016 13.9992C7.0003 13.3549 7.52274 12.8327 8.16707 12.8328L12.8335 12.8338V8.16665C12.8335 7.52231 13.3558 6.99998 14.0002 6.99998C14.6445 6.99998 15.1668 7.52231 15.1668 8.16665V12.8343L19.8337 12.8352C20.4781 12.8354 21.0003 13.3578 21.0002 14.0021C21 14.6465 20.4776 15.1687 19.8333 15.1686L15.1668 15.1676V19.8333C15.1668 20.4776 14.6445 21 14.0002 21C13.3558 21 12.8335 20.4776 12.8335 19.8333V15.1671L8.16659 15.1662Z'
                    fill='#262633'
                />
            </svg>
        </div>
    );

    render() {
        const {
            card: {number, system, isFamilyCard} = {},
            isTouch = false,
            isAdd = false,
            isDisabled = false,
            onClick,
            cardRef
        } = this.props;

        if (isAdd) {
            const Comp = isDisabled ? 'div' : 'a';

            return (
                <Comp
                    className={b({isAdd: !isDisabled, isDisabled})}
                    href={!isDisabled ? CARDS_LINK : undefined}
                    onClick={!isDisabled && onClick}
                >
                    {!isDisabled && this.renderPlusSvg()}

                    <div className={b('textWrap', {top: true, disabled: isDisabled})}>
                        <div className={b('text')}>
                            {isDisabled ? i18n('Profile2.bank_card.add.disabled.top') : i18n('Profile2.bank_card.add')}
                        </div>
                    </div>

                    <div className={b('textWrap', {isHalfWidth: !isDisabled, bottom: true})}>
                        <div className={b('text', {add: true, subText: true})}>
                            {isDisabled
                                ? i18n('Profile2.bank_card.add.disabled')
                                : i18n('Profile2.bank_card.add.bottom')}
                        </div>
                    </div>
                </Comp>
            );
        }

        const isFamilyCardOwner = false; // Ждем флажок из Lpm
        const isShowLogo = this.bank !== 'light' && !isFamilyCard;

        return (
            <div
                ref={cardRef}
                onClick={onClick || this.selectCard}
                className={b({bank: !isFamilyCard && this.bank, family: isFamilyCard})}
            >
                {system && !isFamilyCard && <div className={b('system', {[system.toLowerCase()]: true})} />}
                {isShowLogo && <div className={b('logo', {[this.bank]: true})} />}
                {!isTouch && this.renderSettingsSvg()}
                <div className={b('textWrap', {bottom: true})}>
                    {number && <div className={b('text', {number: true})}>{number.slice(-4)}</div>}
                    {Boolean(isFamilyCard || isFamilyCardOwner) && (
                        <div
                            className={b('text', {
                                family: true,
                                owner: isFamilyCardOwner,
                                subText: isFamilyCardOwner
                            })}
                        >
                            {i18n('Profile2.bank_card.family')}
                        </div>
                    )}
                </div>
            </div>
        );
    }
}

BankCard.propTypes = {
    dispatch: PropTypes.func.isRequired,
    v2: PropTypes.bool,
    onClick: PropTypes.func,
    numberText: PropTypes.string,
    isTouch: PropTypes.bool.isRequired,
    isAdd: PropTypes.bool,
    isDisabled: PropTypes.bool,
    card: PropTypes.object.isRequired,
    cardRef: PropTypes.object
};
