import {connect} from 'react-redux';
import {hasExp} from '@blocks/selectors';
import BankCardsComponent from './bank_cards';

const mapStateToProps = (state) => {
    const {common = {}, billing = {}, settings = {}, phones = {}} = state;
    const {restore = []} = phones;
    const {edit, retpath, v2, uid} = common;
    const {tld, yaPayLanding} = settings;
    const hasRestorePhone = Boolean(restore.length);

    return {
        isOrderHistoryExp: hasExp(state, 'order_history_on'),
        v2,
        uid,
        hasRestorePhone,
        edit,
        retpath,
        settings,
        billing,
        tld,
        yaPayLanding
    };
};

export const BankCards = connect(mapStateToProps)(BankCardsComponent);
