import React from 'react';
import {Button} from '@components/Button';
import {Link} from '@components/Link';

export default class Banner extends React.Component {
    render() {
        return (
            <div className='p-banner'>
                <div className='p-banner__inner'>
                    <div className='p-banner__title font-weight_bold'>Карты вами недовольны (i18n)</div>
                    <div className='p-banner__desc'>
                        <div>Яндекс.Карты терпеть не могут догадываться, где вы там живете и работаете. (i18n)</div>
                        <div>Заполните анкету, а то у вас пробки до 12 баллов отрастут. Поняли? (i18n)</div>
                    </div>
                    <div>
                        <div className='p-banner__button'>
                            <Button view='action' size='l' width='max' cls='p-banner__button-ok'>
                                Взять себя в руки и перестать бесить (i18n)
                            </Button>
                        </div>
                        <div className='p-banner__link'>
                            <Link href='#'>Я понимаю, что это не дело, но сейчас совсем никак (i18n)</Link>
                        </div>
                    </div>
                </div>
                <div className='p-banner__image'>
                    <svg>
                        <use xlinkHref='#Profile_mad_banner' />
                    </svg>
                </div>
            </div>
        );
    }
}
