import React from 'react';
import PropTypes from 'prop-types';

import {Tile} from './tile/tile.jsx';
import AuthBlock from './auth_block/auth_block.jsx';
import {BankCards} from './bank_cards';
import MailsBlock from './mails_block/mails_block.jsx';
import SocialBlock from './social_block/social_block.jsx';
import PersonalInfo from './personal_info/personal_info.jsx';
import HistoryBlock from './history_block/history_block.jsx';
import AddressesBlock from './addresses_block/addresses_block.jsx';
import OtherSettingsBlock from './other_settings_block/other_settings_block.jsx';
import SubscriptionsBlock from './subscriptions/subscriptions';

import {PublicIDModal} from '@screens/PublicId/Modal';
import {SurveyPopup} from '@components/Survey';

import {handleSurveyPopup} from '@blocks/actions/surveyPopup';
import {isMobile} from '@blocks/selectors';

export default class MordaDefault extends React.Component {
    componentDidMount() {
        this.props.dispatch(handleSurveyPopup());
    }

    render() {
        const {
            bnpl,
            order,
            person,
            phones,
            common,
            access,
            emails,
            social,
            devices,
            captcha,
            security,
            settings,
            dispatch,
            addresses,
            changeAvatar,
            appPasswords,
            visibleBlocks,
            getTileClassName,
            mordaSubscriptionCards
        } = this.props;

        const tiles = {
            MailsBlock: visibleBlocks.MailsBlock && (
                <Tile key='mail' className={getTileClassName('mail')}>
                    <MailsBlock
                        isLite={false}
                        person={person}
                        emails={emails}
                        phones={phones}
                        tld={settings.tld}
                        dispatch={dispatch}
                        isPhone={settings.isPhone}
                        isTouch={settings.isTouch}
                        isSocialchik={person.isSocialchik}
                        isNeoPhonish={person.isNeoPhonish}
                        common={common}
                    />
                </Tile>
            ),
            Subscriptions: visibleBlocks.Subscriptions && (
                <Tile key='subscriptions'>
                    <SubscriptionsBlock
                        dispatch={dispatch}
                        subscriptionCards={mordaSubscriptionCards}
                        settings={settings}
                        common={common}
                    />
                </Tile>
            ),
            BankCards: visibleBlocks.BankCards && (
                <Tile key='bankCards' className={getTileClassName('card')}>
                    <BankCards dispatch={dispatch} />
                </Tile>
            ),
            AddressesBlock: visibleBlocks.AddressesBlock && (
                <Tile key='addresses' className={getTileClassName('maps')}>
                    <AddressesBlock common={common} settings={settings} dispatch={dispatch} addresses={addresses} />
                </Tile>
            ),
            SocialBlock: visibleBlocks.SocialBlock && (
                <Tile key='social' className={getTileClassName('social')}>
                    <SocialBlock
                        social={social}
                        access={access}
                        common={common}
                        person={person}
                        dispatch={dispatch}
                        settings={settings}
                    />
                </Tile>
            ),
            AuthBlock: visibleBlocks.AuthBlock && (
                <Tile key='auth' className={getTileClassName('key')}>
                    <AuthBlock
                        phoneNumber={((phones && phones.restore).find((item) => item.isDefault) || {}).number}
                        hasAliasPhone={((phones && phones.restore) || []).some((phone) => phone.isAlias)}
                        hasPhone={Boolean(phones && phones.restore.length)}
                        common={common}
                        access={access}
                        person={person}
                        captcha={captcha}
                        dispatch={dispatch}
                        settings={settings}
                        security={security}
                        appPasswords={appPasswords}
                    />
                </Tile>
            ),
            HistoryBlock: visibleBlocks.HistoryBlock && (
                <Tile key='history' className={getTileClassName('clock')}>
                    <HistoryBlock
                        common={common}
                        devices={devices}
                        settings={settings}
                        dispatch={dispatch}
                        lastAuth={security.lastAuth}
                        havePassword={person.havePassword}
                    />
                </Tile>
            ),
            OtherSettingsBlock: visibleBlocks.OtherSettingsBlock && (
                <Tile key='otherSettings' className={getTileClassName('other-settings')}>
                    <OtherSettingsBlock common={common} settings={settings} dispatch={dispatch} />
                </Tile>
            )
        };

        return (
            <>
                <Tile>
                    <PersonalInfo
                        bnpl={bnpl}
                        person={person}
                        common={common}
                        settings={settings}
                        dispatch={dispatch}
                        changeAvatar={changeAvatar}
                        securityLevel={security.securityLevel}
                        is2faEnabled={access.is2faEnabled}
                        isSms2faEnabled={access.isSms2faEnabled}
                        hasPhone={Boolean(phones && phones.restore.length)}
                        isClosedPhoneAlert={security.isClosedPhoneAlert}
                        isClosed2faAlert={security.isClosed2faAlert}
                    />
                </Tile>
                {order.map((key) => tiles[key])}
                <PublicIDModal />
                {common.edit === 'SHOW_SURVEY' && !isMobile({settings}) && <SurveyPopup />}
            </>
        );
    }
}

MordaDefault.propTypes = {
    bnpl: PropTypes.object,
    dispatch: PropTypes.func.isRequired,
    getTileClassName: PropTypes.func.isRequired,
    isKUBR: PropTypes.bool.isRequired,
    common: PropTypes.object.isRequired,
    access: PropTypes.object.isRequired,
    person: PropTypes.object.isRequired,
    emails: PropTypes.object.isRequired,
    phones: PropTypes.object.isRequired,
    social: PropTypes.object.isRequired,
    devices: PropTypes.object.isRequired,
    billing: PropTypes.object.isRequired,
    captcha: PropTypes.object.isRequired,
    security: PropTypes.object.isRequired,
    settings: PropTypes.object.isRequired,
    addresses: PropTypes.object.isRequired,
    appPasswords: PropTypes.object.isRequired,
    changeAvatar: PropTypes.object.isRequired,
    order: PropTypes.arrayOf(PropTypes.string).isRequired,
    visibleBlocks: PropTypes.shape({
        AuthBlock: PropTypes.bool.isRequired,
        BankCards: PropTypes.bool.isRequired,
        MailsBlock: PropTypes.bool.isRequired,
        SocialBlock: PropTypes.bool.isRequired,
        HistoryBlock: PropTypes.bool.isRequired,
        AddressesBlock: PropTypes.bool.isRequired,
        OtherSettingsBlock: PropTypes.bool.isRequired,
        Subscriptions: PropTypes.bool.isRequired
    }).isRequired,
    mordaSubscriptionCards: PropTypes.object.isRequired
};
