import React from 'react';
import PropTypes from 'prop-types';
import {FamilyCard} from '../../components/FamilyCard';
import {CARDS} from '../../const';

export class FamilyCardCreate extends React.Component {
    onButtonClick = () => this.props.goToInvitePage();
    render() {
        return (
            <FamilyCard
                type={CARDS.create}
                title={i18n('Family.cards.create.title')}
                text={i18n('Family.cards.create.text')}
                buttonProps={{
                    text: i18n('Family.cards.create.button.text'),
                    view: 'action',
                    dataT: 'card-create',
                    onClick: this.onButtonClick
                }}
            />
        );
    }
}

FamilyCardCreate.propTypes = {
    goToInvitePage: PropTypes.func
};
