import React from 'react';
import PropTypes from 'prop-types';
import {FamilyCard} from '../../components/FamilyCard';
import {CARDS, PAGES} from '../../const';

export class FamilyCardKiddish extends React.Component {
    onButtonClick = () => {
        const {goToPage, setCurrentSlot, avatar, loading} = this.props;

        if (!loading) {
            setCurrentSlot({avatar, isEmpty: true, isKiddishOnlyThisStep: false});
            goToPage(PAGES.kiddishName);
        }
    };
    render() {
        return (
            <FamilyCard
                type={CARDS.kiddish}
                title={i18n('Family.cards.kiddish.title')}
                text={i18n('Family.cards.kiddish.text')}
                buttonProps={{
                    text: i18n('Family.cards.kiddish.button.text'),
                    metricKiddish: ['Нажали создать'],
                    view: 'action',
                    dataT: 'kiddish-create',
                    onClick: this.onButtonClick
                }}
            />
        );
    }
}

FamilyCardKiddish.propTypes = {
    avatar: PropTypes.string,
    loading: PropTypes.bool,
    goToPage: PropTypes.func,
    setCurrentSlot: PropTypes.func
};
