import {connect} from 'react-redux';
import {hasExp} from '@blocks/selectors';
import {FamilyCardPay as Card} from './FamilyCardPay';
import {goToPage} from '../../middlewares/routing';
import {setPaySettingsOpenedState} from '../../middlewares/actions/pay';
import {fetchFamily} from '../../middlewares/api/state';

const mapStateToProps = (state) => {
    const {
        family: {
            pay: {cardInfo = {}} = {},
            yourSlotLimitInfo: {currency, balance = 0, isCardActualyEnabled, isEnabled, limit: {limitMode} = {}} = {},
            isPaySettingsOpened = false,
            withPayOrigin = false,
            isAdminAccess = false,
            hasFamily = false,
            loading = true
        } = {},
        settings: {language} = {},
        phones: {restore = []} = {}
    } = state;

    return {
        cardInfo,
        currency,
        balance,
        language,
        isEnabled,
        isPaySettingsOpened,
        isCardActualyEnabled,
        loading,
        isAdminAccess,
        isFamilyPayExp: hasExp(state, 'profile-family-pay-exp') || withPayOrigin || cardInfo.bound,
        hasFamily,
        limitMode,
        isAbleToUsePay: Boolean(restore.length)
    };
};

const mapDispatchToProps = {goToPage, setPaySettingsOpenedState, fetchFamily};

export const FamilyCardPay = connect(mapStateToProps, mapDispatchToProps)(Card);
