import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {FamilyCard} from '../../components/FamilyCard';
import {CARDS} from '../../const';

const ISRAEL_COUNTRY_ID = 181;

const getActiveText = (hasMembers, countryId) => {
    if (countryId === ISRAEL_COUNTRY_ID) {
        return hasMembers
            ? i18n('Family.cards.plus.active.new.text.members.israel')
            : i18n('Family.cards.plus.active.new.text.israel');
    }
    return hasMembers ? i18n('Family.cards.plus.active.new.text.members') : i18n('Family.cards.plus.active.new.text');
};

export class FamilyCardPlus extends Component {
    componentDidMount() {
        const {hasFamilySubscription, isAdminAccess, fetchFamilyOffer, familyOffer = {}, familyId} = this.props;

        if (!hasFamilySubscription && isAdminAccess && familyId !== familyOffer.familyId) {
            fetchFamilyOffer();
        }
    }
    getInactiveButtonProps = () => {
        const {familyLink, isAdminAccess, isFamilyOfferLoading, familyOffer = {}} = this.props;
        const {text, subText} = familyOffer;

        if (isAdminAccess) {
            return {
                showLoader: isFamilyOfferLoading,
                text,
                subText,
                href: familyLink,
                metric: ['Нажатие на кнопку "оформить семейную подписку"'],
                dataT: 'card-plus',
                view: 'plus'
            };
        }
    };
    render() {
        const {hasFamilySubscription, hasMembers, isAdminAccess, locationCountryId, plusHost} = this.props;
        const offerPlusLink = `${plusHost}/my?from=passport-family`;

        return hasFamilySubscription ? (
            <FamilyCard
                type={CARDS.plus}
                showIcon={true}
                title={i18n('Family.cards.plus.active.new.title')}
                subtitle={hasMembers ? i18n('Family.cards.plus.active.new.subtitle.members') : ''}
                text={getActiveText(hasMembers, locationCountryId)}
                link={
                    isAdminAccess && {
                        text: i18n('Family.cards.plus.active.link'),
                        to: offerPlusLink
                    }
                }
            />
        ) : (
            <FamilyCard
                type={CARDS.plus}
                showIcon={true}
                title={i18n('Family.cards.plus.inactive.new.title')}
                text={
                    locationCountryId === ISRAEL_COUNTRY_ID
                        ? i18n('Family.cards.plus.inactive.new.text.israel')
                        : i18n('Family.cards.plus.inactive.new.text')
                }
                buttonProps={this.getInactiveButtonProps()}
            />
        );
    }
}

FamilyCardPlus.propTypes = {
    isAdminAccess: PropTypes.bool,
    hasFamilySubscription: PropTypes.bool,
    hasMembers: PropTypes.bool,
    isFamilyOfferLoading: PropTypes.bool,
    familyLink: PropTypes.string,
    locationCountryId: PropTypes.number,
    tld: PropTypes.string,
    familyId: PropTypes.string,
    plusHost: PropTypes.string.isRequired,
    familyOffer: PropTypes.shape({
        text: PropTypes.string,
        subText: PropTypes.string,
        familyId: PropTypes.string
    }),
    fetchFamilyOffer: PropTypes.func
};
