import {connect} from 'react-redux';
import {FamilyCardPlus as Card} from './FamilyCardPlus';
import {fetchFamilyOffer} from '../../middlewares/api/offer';

const DEFAULT_OFFER = {text: i18n('Plus.subscribe'), subText: '', familyId: ''};

const mapStateToProps = (state) => {
    const {
        family: {
            hasFamilySubscription = false,
            isAdminAccess = false,
            hasFamily = false,
            hasMembers = false,
            familyOffer = DEFAULT_OFFER,
            isFamilyOfferLoading = false,
            familyId
        }
    } = state;

    return {
        hasFamilySubscription,
        isAdminAccess: !hasFamily || isAdminAccess,
        hasMembers,
        familyOffer,
        isFamilyOfferLoading,
        familyId
    };
};

const mapDispatchToProps = {fetchFamilyOffer};

export const FamilyCardPlus = connect(mapStateToProps, mapDispatchToProps)(Card);
