import React from 'react';
import PropTypes from 'prop-types';
import {Link} from '@components/Link';
import {FamilyCard} from '../../components/FamilyCard';
import {FamilyUniversalTile} from '../../components/FamilyUniversalTile';
import {CARDS} from '../../const';

export const FamilyCardPlusSmall = ({hasFamilySubscription, isAdminAccess, plusHost, hasPlus}) => {
    /* eslint-disable max-len */
    const trialMultiPlusLink = `${plusHost}/my/promo-family-option?utm_source=yandexid&utm_medium=passport_menu&utm_campaign=yandexid_plus`;
    const multiPlusLink = `${plusHost}/family?utm_source=yandexid&utm_medium=passport_menu&utm_campaign=yandexid_no_plus`;
    const managePlusSubscription = `${plusHost}/my?from=passport-family`;

    const showPlusMultiTrial = !hasFamilySubscription && isAdminAccess && hasPlus;
    const showPlusMulti = !hasFamilySubscription && isAdminAccess && !hasPlus;
    const showPlusManage = hasFamilySubscription && isAdminAccess;

    if (showPlusManage) {
        return (
            <FamilyCard type={CARDS.plusSmall} tile={true} cardLink={managePlusSubscription}>
                <FamilyUniversalTile
                    type='block'
                    verticalAlignCenter={true}
                    title={i18n('Family.cards.plusSmall.active.title')}
                    description={i18n('Family.cards.plusSmall.active.admin.description')}
                    iconLeft='plus'
                    iconRight='arrowRight'
                />
            </FamilyCard>
        );
    }

    if (showPlusMulti || showPlusMultiTrial) {
        const link = showPlusMulti ? multiPlusLink : trialMultiPlusLink;

        return (
            <FamilyCard type={CARDS.plusSmall} tile={true} cardLink={link}>
                <FamilyUniversalTile
                    type='block'
                    verticalAlignCenter={true}
                    tile={true}
                    title={i18n('Family.cards.plusSmall.title')}
                    description={
                        <Link pseudo={!process.env.BROWSER} href={process.env.BROWSER ? link : undefined}>
                            {i18n('Family.cards.plusSmall.text')}
                        </Link>
                    }
                    iconLeft='plus'
                    iconRight='arrowRight'
                />
            </FamilyCard>
        );
    }

    return null;
};

FamilyCardPlusSmall.propTypes = {
    plusHost: PropTypes.string,
    hasFamilySubscription: PropTypes.bool,
    isAdminAccess: PropTypes.bool,
    hasPlus: PropTypes.bool
};
