import {connect} from 'react-redux';
import {FamilyCardPlusSmall as Card} from './FamilyCardPlusSmall';
import {fetchFamilyOffer} from '../../middlewares/api/offer';

const mapStateToProps = ({
    family: {hasFamilySubscription, isAdminAccess, hasFamily, familyId, yourSlot: {hasPlus} = {}} = {}
}) => ({
    hasFamilySubscription,
    isAdminAccess: !hasFamily || isAdminAccess,
    familyId,
    hasPlus
});

const mapDispatchToProps = {fetchFamilyOffer};

export const FamilyCardPlusSmall = connect(mapStateToProps, mapDispatchToProps)(Card);
