import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import './FamilyAvatar.styl';

const b = cn('FamilyAvatar');

export class FamilyAvatar extends React.Component {
    renderRealAvatar = () => {
        const {slot: {avatar} = {}, avatarUrlTemplate, size, isCurrentSlot, currentSlotAvatar} = this.props;

        return (
            <img
                className={b('img')}
                src={avatarUrlTemplate
                    .replace('%uid%', isCurrentSlot ? currentSlotAvatar : avatar)
                    .replace('%size%', ['l', 'xl'].includes(size) ? '150' : 'retina-middle')}
            />
        );
    };
    renderIcon = () => {
        const {slot: {isInvite, isEmpty} = {}} = this.props;

        return (
            <div className={b('iconWrap')}>
                <div className={b('icon', {isInvite, isEmpty})} />
            </div>
        );
    };
    renderMultiAvatar = () => {
        const {slots, avatarUrlTemplate, size, isMultiAvatar, isTouch} = this.props;

        return slots.map((slot, i) => {
            if (slot.isEmpty || i > 2) {
                return;
            }

            return (
                <img
                    className={b('img', {isMultiAvatar, isTouch})}
                    key={slot.avatar}
                    src={avatarUrlTemplate
                        .replace('%uid%', slot.avatar)
                        .replace('%size%', size === 'l' ? '150' : 'retina-middle')}
                />
            );
        });
    };
    render() {
        const {
            slot: {hasPlus = false, isUser = false, isKiddish = false, isEmpty = false, avatar = ''} = {},
            size,
            isCentered = false,
            noPlus = false,
            onClick,
            ref,
            isMultiAvatar,
            isTouch
        } = this.props;
        const hasAvatar = isUser || isKiddish || (Boolean(avatar) && isEmpty);

        return (
            <div
                className={b({size, isCentered, hasPlus: hasPlus && !noPlus, isMultiAvatar, isTouch})}
                onClick={onClick}
                ref={ref}
            >
                {isMultiAvatar ? this.renderMultiAvatar() : hasAvatar ? this.renderRealAvatar() : this.renderIcon()}
            </div>
        );
    }
}

FamilyAvatar.propTypes = {
    avatarHost: PropTypes.string,
    avatarUrlTemplate: PropTypes.string,
    currentSlotAvatar: PropTypes.string,
    size: PropTypes.oneOf(['xs', 's', 'm', 'l', 'xl']),
    isCentered: PropTypes.bool,
    isTouch: PropTypes.bool,
    isCurrentSlot: PropTypes.bool,
    noPlus: PropTypes.bool,
    onClick: PropTypes.func,
    slot: PropTypes.object,
    ref: PropTypes.object,
    isMultiAvatar: PropTypes.bool,
    slots: PropTypes.array
};
