import {connect} from 'react-redux';
import {FamilyAvatar as Avatar} from './FamilyAvatar.jsx';

const mapStateToProps = (
    {settings: {avatar: {host, pathname} = {}, isTouch}, family: {currentSlot = {}}},
    {isCurrentSlot = false, slot}
) => ({
    avatarHost: host,
    slot: isCurrentSlot ? currentSlot : slot,
    currentSlotAvatar: currentSlot.avatar || '0/0-0',
    avatarUrlTemplate: `https://${host}${pathname}`,
    isTouch
});

export const FamilyAvatar = connect(mapStateToProps)(Avatar);
