import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Link} from 'react-router-dom';
import {Button} from '@components/Button';
import {Spin} from '@components/Spin';
import {cn} from '@bem-react/classname';
import {metrics} from '../../utils/metrics';
import './FamilyButton.styl';

const b = cn('FamilyButton');

export class FamilyButton extends Component {
    onClick = () => {
        const {metric, metricKiddish, onClick, href} = this.props;

        if (metric) {
            metrics.send(metric);
        }
        if (metricKiddish) {
            metrics.sendKiddish(metricKiddish);
        }
        if (!href && onClick) {
            onClick();
        }
    };
    render() {
        const {
            children,
            view,
            text,
            subText,
            href,
            to,
            hideMobile,
            dataT,
            progress,
            showLoader,
            disabled,
            icon
        } = this.props;
        const dataTPrefix = dataT ? `family:button:${dataT}` : 'family:button';
        const realSubText = text && !children && subText;
        const button = (
            <div className={b({hideMobile})} data-t={`${dataTPrefix}:wrap`}>
                <Button
                    width='max'
                    type='button'
                    view={showLoader ? 'clear' : view}
                    size={`family-${realSubText ? 'l' : 'm'}`}
                    onClick={this.onClick}
                    disabled={disabled}
                    data-t={dataTPrefix}
                    progress={progress}
                >
                    {showLoader ? (
                        <Spin progress={true} size='l' />
                    ) : (
                        <div className={b('content')}>
                            <div className={b('text')}>
                                {icon && <span aria-hidden='true' className={b('icon', {icon})} />}
                                {text || children || ' '}
                            </div>
                            {Boolean(realSubText) && (
                                <div className={b('subtext', {plus: view === 'plus'})}>{realSubText}</div>
                            )}
                        </div>
                    )}
                </Button>
            </div>
        );

        if (to || href) {
            const LinkComponent = to ? Link : 'a';

            return (
                <LinkComponent to={to} href={href} className={b('link')} data-t={`${dataTPrefix}:link`}>
                    {button}
                </LinkComponent>
            );
        }

        return button;
    }
}

FamilyButton.propTypes = {
    view: PropTypes.oneOf(['action', 'default', 'transparent', 'plus']).isRequired,
    text: PropTypes.string,
    metric: PropTypes.arrayOf(PropTypes.string),
    metricKiddish: PropTypes.arrayOf(PropTypes.string),
    subText: PropTypes.string,
    href: PropTypes.string,
    to: PropTypes.string,
    children: PropTypes.node,
    onClick: PropTypes.func,
    dataT: PropTypes.string,
    hideMobile: PropTypes.bool,
    progress: PropTypes.bool,
    disabled: PropTypes.bool,
    icon: PropTypes.string,
    showLoader: PropTypes.bool
};
