import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {FamilyButton} from '../FamilyButton';
import {PlusSvgRu, PlusSvgEng, PlusSvgSmall, CardSvgSmall, ArrowRightSvg, PhoneSvg} from './icons';
import './FamilyCard.styl';

const b = cn('FamilyCard');
const dataTPrefix = 'family:card';

const TEXT_ICONS = {
    plus: <PlusSvgSmall />,
    card: <CardSvgSmall />,
    phone: <PhoneSvg />,
    arrowRight: <ArrowRightSvg />
};

export class FamilyCard extends React.Component {
    render() {
        const {
            title,
            subtitle,
            type,
            text,
            textIcon,
            textIconRight,
            children,
            innerRef,
            onClick,
            buttonProps,
            link,
            cardLink,
            bg,
            showIcon,
            isPlusRuLogo,
            small = false,
            tile
        } = this.props;
        const dataT = type ? `${dataTPrefix}:${type}` : dataTPrefix;
        const Component = cardLink ? 'a' : 'div';

        return (
            <Component
                className={b({
                    bg,
                    tile,
                    small,
                    hasBg: Boolean(bg),
                    clickable: Boolean(cardLink || onClick)
                })}
                data-t={dataT}
                href={cardLink}
                onClick={onClick}
                ref={innerRef}
            >
                {children || (
                    <>
                        <div className={b('content')}>
                            <div className={b('top')}>
                                <h3 className={b('title', {showIcon})}>{title}</h3>
                                {showIcon && (
                                    <div className={b('icon', {ru: isPlusRuLogo})}>
                                        {isPlusRuLogo ? <PlusSvgRu /> : <PlusSvgEng />}
                                    </div>
                                )}
                            </div>
                            <div className={b('text')}>
                                {subtitle && <div className={b('subtitle')}>{subtitle}</div>}
                                {TEXT_ICONS[textIcon] || TEXT_ICONS[textIconRight] ? (
                                    <div className={b('textWrap')}>
                                        {TEXT_ICONS[textIcon] && (
                                            <div className={b('textIcon', {icon: textIcon, left: true})}>
                                                {TEXT_ICONS[textIcon]}
                                            </div>
                                        )}
                                        <div className={b('text', {withIcons: true})}>{text}</div>
                                        {TEXT_ICONS[textIconRight] && (
                                            <div className={b('textIcon', {icon: textIconRight, right: true})}>
                                                {TEXT_ICONS[textIconRight]}
                                            </div>
                                        )}
                                    </div>
                                ) : (
                                    text
                                )}
                            </div>
                            {link && (
                                <a className={b('link')} href={link.to} data-t={`${dataT}:link`}>
                                    {link.text}
                                </a>
                            )}
                        </div>
                        {buttonProps && (
                            <div className={b('button')}>
                                <FamilyButton {...buttonProps} />
                            </div>
                        )}
                    </>
                )}
            </Component>
        );
    }
}

FamilyCard.propTypes = {
    type: PropTypes.string,
    title: PropTypes.string,
    subtitle: PropTypes.string,
    text: PropTypes.string,
    bg: PropTypes.string,
    cardLink: PropTypes.string,
    textIcon: PropTypes.string,
    textIconRight: PropTypes.string,
    onClick: PropTypes.func,
    children: PropTypes.node,
    innerRef: PropTypes.object,
    showIcon: PropTypes.bool,
    small: PropTypes.bool,
    tile: PropTypes.bool,
    buttonProps: PropTypes.shape({
        text: PropTypes.string,
        subText: PropTypes.string,
        metric: PropTypes.arrayOf(PropTypes.string),
        metricKiddish: PropTypes.arrayOf(PropTypes.string),
        view: PropTypes.oneOf(['action', 'default', 'plus'])
    }),
    link: PropTypes.shape({
        text: PropTypes.string,
        to: PropTypes.string
    }),
    isPlusRuLogo: PropTypes.bool
};
