import {connect} from 'react-redux';
import {getLanguage} from '@blocks/selectors';
import {FamilyCard as Card} from './FamilyCard';

const mapStateToProps = (state) => {
    const language = getLanguage(state);

    return {isPlusRuLogo: !language || ['ru', 'uk'].includes(language)};
};

export const FamilyCard = connect(mapStateToProps)(Card);
