import React from 'react';
import PropTypes from 'prop-types';
import {CARDS} from '../../const';
import {
    FamilyCardJoin,
    FamilyCardLoading,
    FamilyCardCreate,
    FamilyCardPlus,
    FamilyCardPlusSmall,
    FamilyCardKiddish,
    FamilyCardPay
} from '../../cards';

export const FamilyCardSelector = ({card, familyLink, tld, locationCountryId, plusHost}) => {
    const Card = (() => {
        switch (card.type) {
            case CARDS.loading:
                return FamilyCardLoading;
            case CARDS.join:
                return FamilyCardJoin;
            case CARDS.create:
                return FamilyCardCreate;
            case CARDS.plus:
                return FamilyCardPlus;
            case CARDS.kiddish:
                return FamilyCardKiddish;
            case CARDS.pay:
                return FamilyCardPay;
            case CARDS.plusSmall:
                return FamilyCardPlusSmall;
            default:
                return null;
        }
    })();

    if (!Card) {
        return null;
    }

    return (
        <Card {...card} familyLink={familyLink} tld={tld} locationCountryId={locationCountryId} plusHost={plusHost} />
    );
};

FamilyCardSelector.propTypes = {
    card: PropTypes.object,
    familyLink: PropTypes.string,
    locationCountryId: PropTypes.number,
    tld: PropTypes.string,
    plusHost: PropTypes.string.isRequired
};
