import React from 'react';
import PropTypes from 'prop-types';
import {cn} from '@bem-react/classname';
import {metrics} from '../../utils/metrics';

import './FamilyInviteInput.styl';

const b = cn('FamilyInviteInput');
const dataT = 'family:invite-input';

export class FamilyInviteInput extends React.Component {
    state = {
        isActive: false,
        value: ''
    };
    onInputChange = ({target: {value}}) => {
        this.setState({isActive: Boolean(value.trim().length), value});
    };
    onButtonClick = () => {
        const {sendInvite} = this.props;
        const {isActive, value} = this.state;

        if (isActive && sendInvite) {
            metrics.send(['Отправка приглашения через инпут', value.indexOf('@') !== -1 ? 'email' : 'phone']);
            sendInvite(value);
        }
    };

    render() {
        const {id, placeholderText, isAm} = this.props;
        const {isActive} = this.state;

        return (
            <div className={b({isActive})} data-t={dataT}>
                <input
                    id={id}
                    className={b('input', {isAm})}
                    placeholder={placeholderText}
                    onChange={this.onInputChange}
                    data-t={`${dataT}:input`}
                />
                <button className={b('button', {isAm})} onClick={this.onButtonClick} data-t={`${dataT}:button`}>
                    <div className={b('icon')} />
                </button>
            </div>
        );
    }
}

FamilyInviteInput.propTypes = {
    id: PropTypes.string,
    placeholderText: PropTypes.string,
    sendInvite: PropTypes.func,
    isAm: PropTypes.bool
};
