import {connect} from 'react-redux';
import {FamilyInviteLink as InviteLink} from './FamilyInviteLink';

const mapStateToProps = ({family: {inviteId}, settings: {host, env, tld}}) => {
    const invitePath = `/profile/family/invite/${inviteId}`;
    const envToHost = {
        testing: `https://id-test.yandex.${tld}`,
        production: `https://id.yandex.${tld}`,
        rc: host,
        development: host
    };

    return {
        invitePath,
        inviteLink: `${envToHost[env.type || 'production']}${invitePath}`
    };
};

export const FamilyInviteLink = connect(mapStateToProps)(InviteLink);
