import React from 'react';
import PropTypes from 'prop-types';
import {FamilyAvatar} from '../FamilyAvatar';
import {cn} from '@bem-react/classname';
import './FamilyInviteOptions.styl';

const b = cn('FamilyInviteOptions');
const dataTPrefix = 'family:invite-option';

export const FamilyInviteOptions = ({withHover, isTouch, kiddishAvatars, onKidClick, onAdultClick}) => (
    <div className={b({withHover})} data-t={dataTPrefix}>
        <div className={b('option')} onClick={onAdultClick} data-t={`${dataTPrefix}:adult`}>
            <div className={b('avatar')}>
                <FamilyAvatar slot={{isUser: true, avatar: '0/0-0'}} size='s' isTouch={isTouch} />
            </div>
            <div className={b('text')}>{i18n('Family.invite-options.adult')}</div>
        </div>
        <div className={b('option')} onClick={onKidClick} data-t={`${dataTPrefix}:kiddish`}>
            <div className={b('avatar')}>
                <FamilyAvatar slot={{isKiddish: true, avatar: kiddishAvatars[0]}} size='s' isTouch={isTouch} />
            </div>
            <div className={b('text')}>{i18n('Family.invite-options.kiddish')}</div>
        </div>
    </div>
);

FamilyInviteOptions.propTypes = {
    withHover: PropTypes.bool,
    isTouch: PropTypes.bool,
    kiddishAvatars: PropTypes.array.isRequired,
    onAdultClick: PropTypes.func,
    onKidClick: PropTypes.func
};
