import React from 'react';
import PropTypes from 'prop-types';
import dayjs from 'dayjs';
import {cn} from '@bem-react/classname';
import {PAGES} from '../../const';
import './FamilyKiddishInfo.styl';

const b = cn('FamilyKiddishInfo');
const dataT = 'family:kiddish-info';

const getGenderText = (gender) => {
    switch (gender) {
        case 'm':
            return i18n('Family.kiddish-info.gender.male');
        case 'f':
            return i18n('Family.kiddish-info.gender.female');
        default:
            return i18n('Family.kiddish-info.choose');
    }
};

export class FamilyKiddishInfo extends React.Component {
    goToKiddish = (page) => {
        const {goToPage, updateCurrentSlot} = this.props;

        updateCurrentSlot({isKiddishOnlyThisStep: true});
        goToPage(page);
    };
    onEditKiddishClick = () => this.goToKiddish(PAGES.kiddishOther);
    onEditVideoRatingClick = () => this.goToKiddish(PAGES.kiddishFilms);
    onEditMusicRatingClick = () => this.goToKiddish(PAGES.kiddishMusic);
    render() {
        const {kiddish: {videoRating, gender, birthday} = {}} = this.props;

        return (
            <div className={b({pay: true})} data-t={dataT}>
                <div className={b('item')} data-t='kiddish:info:films'>
                    <div className={b('icon', {video: true})} />
                    <div className={b('text')}>
                        {i18n('Family.kiddish-info.v2.films').replace('%rating', `${videoRating || 0}+`)}
                    </div>
                </div>
                <div
                    className={b('item', {clickable: !birthday})}
                    data-t='kiddish:info:birthday'
                    onClick={!birthday ? this.onEditKiddishClick : undefined}
                >
                    <div className={b('icon', {birthday: true})} />
                    <div className={b('text')}>
                        {birthday
                            ? i18n('Family.kiddish-info.v2.birthday').replace(
                                  '%date',
                                  dayjs(birthday).format('DD.MM.YYYY')
                              )
                            : i18n('Family.kiddish-info.v2.birthday.add')}
                    </div>
                </div>
                <div
                    className={b('item', {clickable: !gender})}
                    data-t='kiddish:info:gender'
                    onClick={!gender ? this.onEditKiddishClick : undefined}
                >
                    <div className={b('icon', {gender: true})} />
                    <div className={b('text')}>
                        {gender
                            ? i18n('Family.kiddish-info.v2.gender').replace('%gender', getGenderText(gender))
                            : i18n('Family.kiddish-info.v2.gender.add')}
                    </div>
                </div>
            </div>
        );
    }
}

FamilyKiddishInfo.propTypes = {
    kiddish: PropTypes.object,
    updateCurrentSlot: PropTypes.func,
    goToPage: PropTypes.func
};
